IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA')
BEGIN

CREATE TABLE [dbo].[RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA](
	[ID]					BIGINT IDENTITY(1, 1) NOT NULL,
	[CD_EMP]				INT NOT NULL,
	[CD_CLI]				INT NOT NULL,
	[CD_FILIAL]				INT NOT NULL,
	[ID_PROMOCAO]			BIGINT NOT NULL,
	[DATA]					DATE NOT NULL,
	[DATA_HORA]				DATETIME NOT NULL,
	CONSTRAINT PK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA PRIMARY KEY CLUSTERED ([ID])
) ON [PRIMARY]

END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_RC_CLI')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_RC_CLI FOREIGN KEY (CD_EMP, CD_CLI) REFERENCES RC_CLI (CD_EMP, CD_CLI)
END
GO

ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_RC_CLI
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_PRC_FILIAL')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_PRC_FILIAL FOREIGN KEY (CD_EMP, CD_FILIAL) REFERENCES PRC_FILIAL (CD_EMP, CD_FILIAL)
END
GO

ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_PRC_FILIAL
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_RC_CLI_BEM_MAIS_PROMOCAO')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_RC_CLI_BEM_MAIS_PROMOCAO FOREIGN KEY (ID_PROMOCAO) REFERENCES RC_CLI_BEM_MAIS_PROMOCAO (ID)
END
GO

ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_RC_CLI_BEM_MAIS_PROMOCAO
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_DATA')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA ADD CONSTRAINT DF_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_DATA DEFAULT GETDATE() FOR [DATA]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_DATA_HORA')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA ADD CONSTRAINT DF_RC_CLI_BEM_MAIS_PROMOCAO_CONSULTA_FILIPETA_DATA_HORA DEFAULT GETDATE() FOR [DATA_HORA]
END
GO